/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.pool;

import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.FlowValue;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.pool.ArrayLengthDef;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.pool.ExactTypeDef;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.pool.MemberDefinition;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.pool.TypeDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;

public class IdentifierPool {
    private final Map<String, List<MemberDefinition>> members = new HashMap<String, List<MemberDefinition>>();
    private final Map<String, List<TypeDefinition>> types = new HashMap<String, List<TypeDefinition>>();

    public IdentifierPool() {
        this.addType("byte", new ExactTypeDef(Type.BYTE_TYPE));
        this.addType("char", new ExactTypeDef(Type.CHAR_TYPE));
        this.addType("double", new ExactTypeDef(Type.DOUBLE_TYPE));
        this.addType("float", new ExactTypeDef(Type.FLOAT_TYPE));
        this.addType("int", new ExactTypeDef(Type.INT_TYPE));
        this.addType("long", new ExactTypeDef(Type.LONG_TYPE));
        this.addType("short", new ExactTypeDef(Type.SHORT_TYPE));
        this.addMember("length", new ArrayLengthDef());
    }

    public boolean matchesMember(String id2, FlowValue node2) {
        List<MemberDefinition> matching = this.members.get(id2);
        if (matching == null) {
            throw new IllegalStateException("Use of undeclared identifier '" + id2 + '\'');
        }
        return matching.stream().anyMatch(it -> it.matches(node2));
    }

    public boolean matchesType(String id2, Type type) {
        List<TypeDefinition> matching = this.types.get(id2);
        if (matching == null) {
            throw new IllegalStateException("Use of undeclared identifier '" + id2 + '\'');
        }
        return matching.stream().anyMatch(it -> it.matches(type));
    }

    public void addMember(String id2, MemberDefinition entry) {
        this.members.computeIfAbsent(id2, k -> new ArrayList()).add(entry);
    }

    public void addType(String id2, TypeDefinition entry) {
        this.types.computeIfAbsent(id2, k -> new ArrayList()).add(entry);
    }

    public boolean memberExists(String id2) {
        return this.members.containsKey(id2);
    }

    public boolean typeExists(String id2) {
        return this.types.containsKey(id2);
    }
}

